#SUM minute interval JBT05 AV Meter data to 15 minute interval flow so that it can be aggregated with JBT05 Flowmeter dataset.
getwd()
setwd("O:/Proj-15/WRM/15-309 LCBP Jewett Brook Tile Drain Study/Data/Loading Calcs/FlowLinkEditedFiles/R")

library(dplyr)
library(padr)
JBT05AV <- read.csv(file="jbt05AVMeter_EditedV3_forR.csv", header=TRUE,stringsAsFactors=FALSE)
JBT05AV$DT<-as.POSIXct(JBT05AV$Isco.Quantity, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

get_interval(JBT05AV$DT)

JBT0515minflw<-JBT05AV%>%thicken("15 min")%>%group_by(DT_15_min)%>%summarize(Volume=sum(Edited.Volume),Flag=min(Flag),Comment=min(Comment))
write.csv(JBT0515minflw, "JBT0515minflw_rexport.csv")

JBT06 <- read.csv(file="JBT06_V5.csv", header=TRUE,stringsAsFactors=FALSE)
JBT06$DT<-as.POSIXct(JBT06$DateTime_EDT, format="%m/%d/%Y %H:%M",tz="Etc/GMT+4")

get_interval(JBT06$DT)

JBT0615minflw<-JBT06%>%thicken("15 min")%>%group_by(DT_15_min)%>%summarize(Volume=sum(Corrected.Flow_L.elapsed.time),Flag=min(Flag),Comment=min(Comment))
write.csv(JBT0615minflw, "JBT0615minflw_rexport.csv")